//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//constructed 4/2/05

//strategy option to choose between stealing own, anothers, or humans

FreeImprovisationVoice {

	var <bus; 
	var oscresponder;
	
	var <ownideas, <mostrecentidea; //stores own most recent, can be stolen by others as one option
	
	//characteristics
	var taciturnity, speed,sloppiness,keen,shyness,root;
	var insularity, humanity, energy; //probs of theft from particular places
	//var faithfulness; //make up own durations or use the stored values
	
	var playstyle, playoverlap, playflag, <>playon;
	
	var num; //which SynthDef to use, which number artificial am I? 
	
	var onsetdetector; 
	
	var s;
	
	
	*new {arg num,s;
		^super.new.initFreeImprovisationVoice(num,s);	
	}
	
	initFreeImprovisationVoice {arg n, server;
	
		s=server;
		
		num=n;
		
		bus=Bus.audio(s,1); 
	
		taciturnity= rrand(0.9,1.1); 
		speed= 0.0; //all ready to go immediately at first 
		sloppiness= rrand(0.0,1.0); 
		energy= [0.0,0.01,0.05,0.1,0.2].choose;//playing speed
		keen= [0.0,1.0,rrand(0.0,0.5),exprand(0.1,1.0)].wchoose([0.1,0.2,0.3,0.4]);//inverse playing reluctance
		shyness= exprand(0.2,1.0);  //rrand(0.1,0.25)//playing loudness
		root= rrand(-24,24);//transposition
		
		insularity= rrand(0.0,1.0);
		humanity=1.0; //rrand(0.0,1.0);
		
		ownideas= Array.fill(10,{arg i; Array.fill(rrand(1,3),{[([0,2,3,5,5.7,7,10,12].choose)+([60,48].choose),
		[rrand(0.01,0.03),exprand(0.01,0.5),rrand(0.1,0.5)].wchoose([0.7,0.27,0.03])
		]}); });
		
		playstyle=0;
		playoverlap=false;
		playflag=false;
		playon=true;
		
		mostrecentidea=0;
		
	}
	
	
	setuplistening {arg busses, group;
	
		onsetdetector= SynthDef(\freeimprovisationlistening++num,{arg threshold=0.9;
		var input;
		
		input= Mix.fill(busses.size,{arg j;
		InFeedback.ar(busses[j],1);
		});
		
		OnsetDetection.ar(input,threshold,bus.index); //same trig ID as own bus number
		
		}).play(group,[\threshold,taciturnity],addAction:\addToHead);
	
	}
	
	
	setupresponder {arg artificials, humans, synthgroup, clock;
		var selectprobs, indices; 
		
		selectprobs= Array.series(10,1,1).reverse.normalizeSum; 
		indices= Array.series(10,0,9);
		
		 OSCresponderNode(s.addr,'/tr',{	 arg time,responder,msg;
				var id,dur,freq; 
				
				id=msg[2];
								
				if((id==(bus.index)),{	
					
					//["artificial", id,bus.index].postln;
					//[\voicetrigger,id].postln;
					
					//every 20 change your playing mode
					if(0.05.coin,{
					onsetdetector.set(\threshold,exprand(0.8,1.1));
					speed= [0.0,rrand(0.0,0.2),exprand(0.01,1.0),rrand(0.0,2.0)].wchoose([0.5,0.3,0.15,0.05]); 
					sloppiness= rrand(0.0,1.0); 
					energy= [0.0,0.01,0.05,0.1,0.2].choose;
					keen=[0.0,1.0,rrand(0.0,0.5),exprand(0.1,1.0)].wchoose([0.1,0.2,0.3,0.4]);
					shyness= exprand(0.2,1.0); //rrand(0.1,0.25);
					root= [0.0,rrand(-24,24)].wchoose([0.8,0.2]);
					insularity= rrand(0.0,1.0);
					humanity=[1.0,rrand(0.7,1.0),exprand(0.01,1.0)].choose;
					
					playstyle=[0,1].wchoose([0.8,0.2]); //[0,1].choose;
					//overlap may depend on playstyle
					playoverlap=[false,true].wchoose([0.3,0.7]); //[false,true].wchoose([0.7,0.3]);
					
					});
					
					//id.postln;
			
				if(playoverlap || not(playflag), {
			
				if((keen.coin) && playon,{
					Routine({
					var material, which, whichone, ishuman;
					speed.wait;
					
					ishuman=false;
					
					which= if(humanity.coin,{
						
						ishuman=true;	
						
						whichone=humans.choose;
						
						whichone.ownideas[((whichone.mostrecentidea)- (indices.wchoose(selectprobs)))%10]; 
						
						
					},{
					
					if(insularity.coin,{
						
						whichone=ownideas.size.rand;
						
						mostrecentidea=whichone;
						
						ownideas[whichone];
					
					},{
						
						whichone=artificials.choose;
						
						whichone.ownideas[((whichone.mostrecentidea)- (indices.wchoose(selectprobs)))%10]; 
						
					});
					
					
					});
					
					//which.postln;
					
					//choose from human motifs, ownideas or stealing from another articial
					//material= 
					
					//which=ownideas.size.rand;
					//(ownideas[which])
					
					if(which.notNil,{
					
					playflag=true;
					
					which.do({arg val;
					var ioi;
					//val.postln;
					
					freq=if(ishuman,{val[0]}, {(val[0]+(root)).midicps;});
					
					ioi=val[1];
					//dur=if(freq>200,{[rrand(0.01,0.03),exprand(0.01,0.5),rrand(0.1,0.5)].wchoose([0.7,0.27,0.03])},0.015);
					
					dur= 0.05+(0.5*sloppiness);
					
					//[freq,dur,i].postln;
					
					//[\freeimprovisation++(num),bus.index,freq,shyness,dur].postln;
					//\freeimprovisation++(num)
					//num+5
					Synth.head(synthgroup,\freeimprovisation++((num%5)+5),[\bus,bus.index,\freq,freq,\amp,shyness,\dur,dur]); 
					
					
					if(playstyle==1,{
					//energy+rrand(0.0,0.01)
					(ioi+(sloppiness*rrand(0.0,0.1))).wait;
					},{
					(energy+(sloppiness*rrand(0.0,0.01))).wait
					});
					
					
					});
					});
					
					playflag=false;
					
					}).play(clock);
				});
				
				});
				
		
			});
				
		
		}).add;
		
			
	
	}


	
	*initClass {
	
	StartUp.add({
	
SynthDef.writeOnce(\freeimprovisation3,{arg bus=16,freq=1000,amp=0.2, dur=0.015;
var voice;

//voice= RLPF.ar(Impulse.ar(freq,0,2*(amp+(Rand(0.0,0.01)))),freq,0.1)*Line.kr(1,0,0.015,doneAction:2);

voice= RLPF.ar(PinkNoise.ar((2*amp+(Rand(0.0,0.01)))),freq,0.02)*EnvGen.kr(Env([0,1,0],[0.01,dur]),doneAction:2);

Out.ar(bus,voice)
});

SynthDef.writeOnce(\freeimprovisation4,{arg bus=16,freq=1000,amp=0.2, dur=0.015;
var voice;

voice= RLPF.ar(Impulse.ar(freq,0,4*(amp+(Rand(0.0,0.01)))),freq,0.1)*Line.kr(1,0,dur,doneAction:2);

Out.ar(bus,voice)
}).writeDefFile;

SynthDef(\freeimprovisation5,{arg bus=16,freq=1000,amp=0.2, dur=0.025;
var voice;

voice= RHPF.ar(LFSaw.ar(freq,0,0.25*(amp+(Rand(0.0,0.01)))),3*freq,0.1)*Line.kr(1,0,dur,doneAction:2);

Out.ar(bus,voice)
});


SynthDef.writeOnce(\freeimprovisation1,{arg bus=16,freq=1000,amp=0.2, dur=0.015;
var voice;

voice= RLPF.ar(LFNoise0.ar(freq,(amp+(Rand(0.0,0.01)))),freq,0.1)*Line.kr(1,0,dur,doneAction:2);

Out.ar(bus,voice)
}).writeDefFile;

SynthDef(\freeimprovisation2,{arg bus=16,freq=1000,amp=0.2, dur=0.015;
var voice;

voice= RLPF.ar(BrownNoise.ar((amp+(Rand(0.0,0.01)))),freq,0.02)*Line.kr(1,0,dur,doneAction:2);

Out.ar(bus,voice)
});
//
//SynthDef(\freeimprovisationimpulse,{arg bus=16,amp=0.5, dur=0.015;
//var voice;
//
//voice= Impulse.ar(1,amp)*Line.kr(1,0,dur,doneAction:2);
//
//Out.ar(bus,voice)
//}).writeDefFile;


//voices from MotherFuga/Decison
//adapted from jmc's synthetic piano
SynthDef.writeOnce(\freeimprovisation6, {arg bus=16,freq=1000,dur=0.015,amp=0.2; 
	var delayTime, output, detune, strike, hammerEnv, hammer, lfo;

strike = Impulse.ar(0.0,0.0,0.1);
//strike = Impulse.ar(Rand(0.1,0.5), Rand(0,2pi), 0.1); // random period for each key
hammerEnv = Decay2.ar(strike, 0.008, 0.04); // excitation envelope

lfo=SinOsc.kr(Rand(0.13,0.6),0, LFNoise0.kr(Rand(5.1,9.05),0.15,0.85)*amp*0.1,amp);

// array of 3 strings per note
output=	Mix(Array.fill(3, { arg i;
		// detune strings, calculate delay time :
		detune = #[-0.01, 0, 0.01].at(i);
		delayTime = 1 / (freq*(1+detune));
		// each string gets own exciter :
		hammer = LFNoise2.ar(3000, hammerEnv); // 3000 Hz was chosen by ear..

		CombL.ar(hammer,		// used as a string resonator
			delayTime, 		// max delay time
			delayTime,			// actual delay time
			6) 				// decay time of string
	}));

Out.ar(bus,10*lfo*output*EnvGen.ar(Env.perc(0.01,dur),doneAction:2));//output.dup

});


SynthDef.writeOnce(\freeimprovisation7,{
arg bus, freq, amp=1.0, dur=1.0;
var knock, imp;
var harm, vol;

freq=freq*0.5;

knock= EnvGen.ar(Env.perc(0.01,0.05,1.0,Rand(-10,-4)))*RLPF.ar(WhiteNoise.ar,(4.1*freq+(amp*1000)).max(2000),Rand(0.3,0.4));

harm= #[0.48,1.0,3.01,4.0,5.04,2.007];
vol= #[0.9,0.8,0.3,0.7,0.2,0.4]; 

imp= 0.1*(0.3+0.7*(1-(dur.min(1.0))))*Klang.ar(`[harm*freq,vol,nil]);

imp= imp*amp + (0.5*knock*(amp.max(0.05)));
 
imp= CombN.ar(imp, 0.1, freq.reciprocal*0.5, dur, 1.0, imp);  
 
Out.ar(bus,
EnvGen.ar(
Env.perc(0.01,dur,1.0,4)
, doneAction:2)*
(imp)
)
});


SynthDef.writeOnce(\freeimprovisation8,{
arg bus, freq, amp=1.0, dur=1.0;
var knock, imp, fback;
var harm, atk, vol;

freq=freq*0.5;

knock= EnvGen.ar(Env.perc(0.01,0.05,1.0,Rand(-10,-4)))*RLPF.ar(WhiteNoise.ar,(4.1*freq+(amp*1000)).max(2000),Rand(0.3,0.4));

harm= #[1.0,2.007, 3.01,4.0,5.04, 6.01]; 
vol= #[1.0,0.8,0.3,0.8,0.2,0.7]; 

imp= 0.1*(0.3+0.7*(1-(dur.min(1.0))))*Klang.ar(`[harm*freq,vol,nil]);

imp= imp*amp + (0.4*knock*(amp.max(0.05)));
 
imp= CombN.ar(imp, 0.1, freq.reciprocal*0.5, dur, 1.0, imp);  
 
Out.ar(bus,
EnvGen.ar(
Env.perc(0.01,dur,1.0,4)
, doneAction:2)*
(imp*0.5)
)
});


SynthDef.writeOnce(\freeimprovisation9, {arg bus=16,freq=1000,dur=0.015,amp=0.2; 
	var delayTime, output, detune, strike, hammerEnv, hammer, lfo;

strike = Impulse.ar(0.0,0.0,0.1);
//strike = Impulse.ar(Rand(0.1,0.5), Rand(0,2pi), 0.1); // random period for each key
hammerEnv = Decay2.ar(strike, 0.01, 0.07); // excitation envelope

// array of 3 strings per note
output=	Mix(Array.fill(2, { arg i;
		// detune strings, calculate delay time :
		detune = #[-0.0005, 0.0005].at(i);
		delayTime = 1 / (freq*(1+detune));
		// each string gets own exciter :
		hammer = LFNoise2.ar(Rand(5000,6000), hammerEnv); // 3000 Hz was chosen by ear..

		CombL.ar(hammer,		// used as a string resonator
			delayTime, 		// max delay time
			delayTime,			// actual delay time
			4) 				// decay time of string
	}));
//Env.perc(0.01,dur)
Out.ar(bus,6*amp*output*EnvGen.ar(Env([0,1,1,0],[0.01,dur*0.5,dur*0.5]),doneAction:2));//output.dup

});


SynthDef.writeOnce(\freeimprovisationreverb,{
arg i_out=0, mix=0.02;
var a,c,z,y,in;
c = 7; // number of comb delays
a = 4; // number of allpass delays

in=Limiter.ar(In.ar(i_out,2),0.95);
// reverb predelay time :
z = DelayN.ar(in, 0.048,0.048);

//for delaytime if want modulation-	//LFNoise1.kr(0.1.rand, 0.04, 0.05)
y=Mix.arFill(c,{CombL.ar(z,0.1,rrand(0.01, 0.1),5)});
	
// chain of 4 allpass delays on each of two channels (8 total) :
a.do({ y = AllpassN.ar(y, 0.051, [rrand(0.01, 0.05),rrand(0.01, 0.05)], 1) });
	
// add original sound to reverb and play it :
ReplaceOut.ar(i_out,in+(mix*y));
});	
	
	});
	
	}

}